SET CMDSEP / 

DROP PROCEDURE FDQA_Set_Values
/

CREATE PROCEDURE FDQA_Set_Values(
  IN IN_BYTEINT BYTEINT, IN IN_SMALLINT SMALLINT, IN IN_INTEGER INTEGER, IN IN_FLOAT FLOAT,
  IN IN_DECIMAL DECIMAL(19,4), IN IN_DATE DATE, IN IN_TIME TIME, IN IN_TIMESTAMP TIMESTAMP,
  IN IN_CHAR CHAR(10), IN IN_NCHAR CHAR(10) CHARACTER SET UNICODE, IN IN_VARCHAR VARCHAR(10),
  IN IN_NVARCHAR VARCHAR(10) CHARACTER SET UNICODE, IN IN_CLOB CLOB, IN IN_NCLOB CLOB CHARACTER SET UNICODE,
  IN IN_BYTE BYTE(10), IN IN_VARBYTE VARBYTE(10), IN IN_BLOB BLOB)
BEGIN   
  INSERT INTO "FDQA_All_types"(TBYTEINT, TSMALLINT, TINTEGER, TDOUBLE, TDECIMAL, TDATE, 
      TTIME, TTIMESTAMP, TCHAR, TNCHAR, TVARCHAR, TNVARCHAR, TCLOB, TNCLOB, TBYTE, TVARBYTE, TBLOB)
    VALUES (IN_BYTEINT, IN_SMALLINT, IN_INTEGER, IN_FLOAT, IN_DECIMAL, IN_DATE, 
      IN_TIME, IN_TIMESTAMP, IN_CHAR, IN_NCHAR, IN_VARCHAR, IN_NVARCHAR, IN_CLOB, IN_NCLOB, IN_BYTE, IN_VARBYTE, IN_BLOB);
END;
/

DROP PROCEDURE FDQA_All_Values
/

CREATE PROCEDURE FDQA_All_Values(
  IN I_BYTEINT BYTEINT, IN I_SMALLINT SMALLINT, IN I_INTEGER INTEGER, IN I_FLOAT FLOAT,
  IN I_DECIMAL DECIMAL(19,4), IN I_DATE DATE, IN I_TIME TIME, IN I_TIMESTAMP TIMESTAMP,
  IN I_CHAR CHAR(10), IN I_NCHAR CHAR(10) CHARACTER SET UNICODE, IN I_VARCHAR VARCHAR(10),
  IN I_NVARCHAR VARCHAR(10) CHARACTER SET UNICODE /*, IN I_CLOB CLOB, IN I_NCLOB CLOB CHARACTER SET UNICODE*/,
  IN I_BYTE BYTE(10), IN I_VARBYTE VARBYTE(10) /*, IN I_BLOB BLOB*/,
  OUT O_BYTEINT BYTEINT, OUT O_SMALLINT SMALLINT, OUT O_INTEGER INTEGER, OUT O_FLOAT FLOAT,
  OUT O_DECIMAL DECIMAL(19,4), OUT O_DATE DATE, OUT O_TIME TIME, OUT O_TIMESTAMP TIMESTAMP,
  OUT O_CHAR CHAR(10), OUT O_NCHAR CHAR(10) CHARACTER SET UNICODE, OUT O_VARCHAR VARCHAR(10),
  OUT O_NVARCHAR VARCHAR(10) CHARACTER SET UNICODE /*, OUT O_CLOB CLOB, OUT O_NCLOB CLOB CHARACTER SET UNICODE*/,
  OUT O_BYTE BYTE(10), OUT O_VARBYTE VARBYTE(10) /*, OUT O_BLOB BLOB*/)
BEGIN
  SET O_BYTEINT = I_BYTEINT;
  SET O_SMALLINT = I_SMALLINT;
  SET O_INTEGER = I_INTEGER;
  SET O_FLOAT = I_FLOAT;
  SET O_DECIMAL = I_DECIMAL;
  SET O_DATE = I_DATE;
  SET O_TIME = I_TIME;
  SET O_TIMESTAMP = I_TIMESTAMP;
  SET O_CHAR = I_CHAR;
  SET O_NCHAR = I_NCHAR;
  SET O_VARCHAR = I_VARCHAR;
  SET O_NVARCHAR = I_NVARCHAR;
  -- SET O_CLOB = I_CLOB;
  -- SET O_NCLOB = I_NCLOB;
  SET O_BYTE = I_BYTE;
  SET O_VARBYTE = I_VARBYTE;
  -- SET O_BLOB = I_BLOB;
END;
/

DROP PROCEDURE FDQA_Get_values
/

CREATE PROCEDURE FDQA_Get_values()
  DYNAMIC RESULT SETS 1
BEGIN
  DECLARE cur1 CURSOR WITH RETURN ONLY FOR
          SELECT TBYTEINT, TSMALLINT, TINTEGER, TDOUBLE, TDECIMAL, TDATE, TTIME, TTIMESTAMP, 
                 TCHAR, TNCHAR, TVARCHAR, TNVARCHAR, TCLOB, TNCLOB, TBYTE, TVARBYTE, TBLOB
          FROM "FDQA_All_types";
  OPEN cur1;
END;
/

DROP PROCEDURE FDQA_TestBinding
/

CREATE PROCEDURE FDQA_TestBinding (
  IN p1 integer, p2 varchar(10), out p3 integer, out p4 varchar(10))
BEGIN
  SET p3 = p1 * 10;
  SET p4 = p2 || '**';
END;
/

DROP PROCEDURE FDQA_MCRS
/

CREATE PROCEDURE FDQA_MCRS(IN in_1 integer, IN in_2 integer, 
                           OUT out_1 integer, OUT out_2 integer,
                           INOUT inout_1 integer, INOUT inout_2 integer)
  DYNAMIC RESULT SETS 2
BEGIN
  DECLARE cur1 CURSOR WITH RETURN ONLY FOR
          SELECT * FROM "Categories";
  DECLARE cur2 CURSOR WITH RETURN ONLY FOR
          SELECT * FROM "Territories";
  OPEN cur1;
  OPEN cur2;
  SET out_1 = in_1 * 10;
  SET out_2 = in_2 * 20;
  SET inout_1 = inout_1 * 30;
  SET inout_2 = inout_2 * 40;
END;
/
